/*  
 * Copyright (C) 2005 Martin Pischky (mailto:martin@pischky.de)  
 *
 * This file (Memory.java) is part of IntelHexFile.
 *
 * IntelHexFile is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 */

/*
 * $Log: Memory.java,v $
 * Revision 1.1  2005/03/27 12:29:58  pischky
 * added
 *
 */

package org.fremo.ihx;

/**
 * @author martin
 */
public interface Memory {
    
    /** the lowest possible address in an intel hex file */
    public static final int ADDRESS_LOW  = 0x0000;

    /** the highest possible address in an intel hex file */
    public static final int ADDRESS_HIGH = 0xFFFF;
    
    public static final short UNDEFINED = -1;

    /**
     * Set the value of a given address. Also defined the address.
     * A defined address will be written to a hex file.
     * @param address (0..65535)
     * @param value (-128..255)
     * @throws InvalidAddressException
     */
    public void set( int address, byte value ) 
    throws InvalidAddressException;

    /**
     * Set the value of a given address. Also defined the address.
     * @param address
     * @param value
     * @throws InvalidAddressException
     */
    public void set( int address, int value ) 
    throws InvalidAddressException;

    /**
     * return the value of a given address.
     * When the addess is undefined UNDEFINED ist returned.
     * @param address (0..65535)
     * @return (Memory.UNDEFINED,0..255)
     * @throws InvalidAddressException
     */
    public short get( int address )
    throws InvalidAddressException;

    /**
     * return if the address is defined.
     * A defined address will be written to a hex file.
     * @param address
     * @return
     * @throws InvalidAddressException
     */
    public boolean isDefined( int address )
    throws InvalidAddressException;
    
    /**
     * Sets an memory location to unused.
     * @param address
     * @throws InvalidAddressException
     */
    public void undefine( int address )
    throws InvalidAddressException;

    /**
     * return the next address that is used after a given address.
     * -1 is retuned if there is no more data.
     * @param address
     * @return 
     */
    public int nextUsedAddress( int address )
    throws InvalidAddressException;
    
}
